//　表をリセットする
tablereset():=(
  forall(allpoints(),removeelement(#));

  create(["SW"],"FreePoint",[[-20,-20,1]]);
  create(["NE"],"FreePoint",[[40,20,1]]);
);

// 表を作る bool がfalseのときは縦罫線なし
maketable(tblstr,sep,indexpos,position):=
     maketable(tblstr,sep,indexpos,position,true);
maketable(tblstr,sep,indexpos,position,bool):=(
 // 変数：表の中に入れる文字,tblの転置，行数，列数，列ごとの文字数の最大値，縦，横
  regional(tbl,tbltr,rowno,colno,colen,tate,yoko,rmv);

  if(tblstr_(-1)==unicode("000a"),
   tblstr=substring(tblstr,0,length(tblstr)-1);
  );

  sep=[unicode("000a"),sep];
  tbl=tokenize(tblstr,sep);
  if(tbl_(-1)==[],
    tmp=[];
    repeat(length(tbl)-1,s,append(tmp,tbl_s));
    tbl=tmp;
  );
  tbltr=transpose(tbl);

//チェック用にコンソールに出す
// 縦横が合わない場合，tbltrでエラーメッセージが出る
  println(tbl);
  println(tbltr);

  rowno=length(tbl);
  colno=length(tbltr);

  tate=apply(1..rowno,8);
  yoko=makeyoko(tbltr);

  if(bool,rmv=[],rmv=omitline(rowno,colno));

  Tabledata("",yoko,tate,rmv);

  repeat(colno,s,
    Putcell(s,1,indexpos_s,halfspcut(tbl_1_s));
  );

  repeat(rowno-1,t,
    repeat(colno,s,
      Putcell(s,t+1,position_s,halfspcut(tbl_(t+1)_s));
    );
  );
);



// 各列の長さを決める。数式($・・$)があれば長さを半分にする。長さのリストを返す。
makeyoko(tbltr):=(
  regional(ret,len,math);

  ret=[];
  repeat(length(tbltr),s,
    len=max(apply(tbltr_s,t,length(t)))*5;
    len=max([len,10]);
    math=false;
    forall(tbltr_s,str,
      if(isstring(str),
        if(indexof(str,"$")>0,math=true);
      );
    );
    if(math,len=len/2);
    ret=append(ret,len);
  );
  ret;
);

//縦線を除外線とするリストを作る
omitline(rowno,colno):=(
  regional(ret);

  range="r0r"+text(rowno);
  ret=[];

  repeat(colno+1,s,
    ret=append(ret,"c"+text(s-1)+range);
  );
  ret;
);

// 文字列から前方の半角スペースと#を除去する
halfspcut(str):=(
  regional(t,ret);

  if(isstring(str),
    if(length(str)>0,
      t=0;
      while(str_(t+1)==" ",t=t+1);
      ss=substring(str,t,length(str));
    );

  // # を除去
    ret="";
    repeat(length(str),s,
      if(and(s==1,str_s=="#"),,ret=ret+str_s);
    );
   ,
   ret=str;
  );
  ret;

);
